%%%% Analysis for Android Haptics HW assessment
%%%% Input type :  Effect3 
%%%% Version : 1.0
%%%% Purpose : Release
%%%% Date: 05/18/2020 

clear
clc
close all


%%%%%%%%%%%%%%%%
%%%%% USER INPUTS %%%%%%%
Ring_stop=1200e-3;% Stop time of the simulation (defines end of TAIL time)
%%%%%%%%% Your input .wav function should be located at the same folder as this function. 


%%%%Calibration value for the 3 Axis Accelerometer -  %%%%%%
Cal=0.5/1.414; % Calibration value for 3 axis accelerometer --> Digital value per Gpeak 
%%%%% In this setting 0.5 value in Audacity corresponds to 1.414 Gpeak
%%%%% Value Depends on Amplifier settings, accelerometer type.(Current "Cal" Value given for
%%%%% Endevco 35c-10 with 100X gain setting in the CCLD signal conditioner) 
%%%% Suggest to use a calibrator to calculate the exact calibration factor
%%%% for each accelerometer and CCLD amplifier condition. 


prompt = {'Enter name of the file'};
dlgtitle = 'File name';
dims = [1 35];
definput = {'effect_3.wav'};
answer = inputdlg(prompt,dlgtitle,dims,definput);


[y,Fs]=audioread(answer{1}); %% .wav file as the input function 

%%%%%%HARD INPUTS (Suggest - DO NOT CHANGE) %%%%%%%%
Low_end_threshold = 0.005; % Set low end thredshold as 1% --> DO NOT CHANGE
High_end_threshold = 0.1; % Set high end thredshold as 10% --> DO NOT CHANGE
Stop_end_threshold = 0.001; % Set stop end thredshold as 1% --> DO NOT CHANGE

%%%%Low Pass Filter to Eliminate High Frequency Effects - Do NOT CHANGE%%%%%%
LPF.ord = 2;  % Order of Filters (Higher = stronger filtering)
LPF.sR = 48000; % Sample Rate of Filter 

LPF.type = 'low' ; % Filter Type: Low Pass Filter 
LPF.lpfcut = 5000;   % Low Pass Cutoff Freq. in Hz.

% Design Low  Pass Filter
[b,a]=butter(LPF.ord,LPF.lpfcut/(LPF.sR/2),LPF.type);


%%%%% Code %%%%%%%
Per=(1/Fs);
t=Per:Per:size(y,1)*Per;
y=y./Cal;
X=filtfilt(b,a,y(:,1));

figure(1)
plot(t,X,'b')
title('Set time_gap_start and time_gap_end variables based on this plot','Interpreter', 'none','Fontsize',16)
xlabel('time(s)')
ylabel('amplitude(gee)')
grid on

prompt = {'Enter start time of signal (sec):','Enter end time of signal(sec):'};
dlgtitle = 'Input parameters';
dims = [1 35];
definput = {'0','2'};
answer = inputdlg(prompt,dlgtitle,dims,definput);

time_gap_start=str2num(answer{1}); %Set start time of the actual signal based on figure(1)
time_gap_end=str2num(answer{2}); % Set stop time of the actual signal based on figure(1)

startf = round(time_gap_start*Fs);
if startf==0 
    startf=1 ;
end
endf = round(time_gap_end*Fs);

t1= t(startf:endf)-t(startf);
X1= X(startf:endf);


R_stop=floor(Ring_stop/(1/Fs));

absX1=(abs(X1));
X1_mx=find(absX1==max(absX1));

min_time=find(abs(X1)<Low_end_threshold*max(abs(X1)));
min_time=find(min_time<X1_mx);
X1_low=min_time(end):X1_mx;


t1=t1(X1_low(1):end)-t1(X1_low(1));
X1=X1(X1_low(1):end);


absX1=(abs(X1));
X1_mx=find(absX1==max(absX1));


if X1(X1_mx)<0
TF=islocalmin(X1);
TF2=find(TF==1 & X1 < 0);
else
TF=islocalmax(X1);
TF2=find(TF==1 & X1 > 0);
end

for i=1:size(TF2,1)
    k=i;
    if abs(X1(TF2(i)))<abs(X1(X1_mx))*Stop_end_threshold
        R_stop1=TF2(i);
        break
    end
end

if R_stop1>R_stop
    R_stop=R_stop1;
end

if size(t1,2)<R_stop
    R_stop=size(t1,2);
end

t1=t1(1:R_stop);
X1=X1(1:R_stop);

t1_Accel1=t1(round(0.25*Fs):round(0.4*Fs));
t1_Accel2=t1(round(0.75*Fs):round(0.9*Fs)); 

Accel1=X1(round(0.25*Fs):round(0.4*Fs));
Accel2=X1(round(0.65*Fs):round(0.8*Fs)); 


figure(2)
plot(t1,X1,'g',t1_Accel1,Accel1,'b',t1_Accel2,Accel2,'r')
legend('Actual Signal','50% amplitude steady state region','100% amplitude steady state region')
ylabel('Acceleration (gee)');xlabel('time(s)')
title('Effect 3 Acceleration Profile')
grid on


Max_Amplitude_Accel1=abs(max(Accel1(floor(size(Accel1,1)*0.5):size(Accel1,1))))
Max_Amplitude_Accel2=abs(max(Accel2(floor(size(Accel2,1)*0.5):size(Accel2,1))))
Ratio_Accel2_to_Accel1=Max_Amplitude_Accel2/Max_Amplitude_Accel1


return

